/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.entities.item;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import technology.rocketjump.undermount.assets.entities.item.model.ItemEntityAsset;
import technology.rocketjump.undermount.assets.entities.item.model.ItemStyle;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;

public class ItemEntityAssetsByStyle {
    private EnumMap<ItemStyle, List<ItemEntityAsset>> styleMap = new EnumMap(ItemStyle.class);

    public ItemEntityAssetsByStyle() {
        for (ItemStyle itemStyle : ItemStyle.values()) {
            this.styleMap.put(itemStyle, new ArrayList());
        }
    }

    public void add(ItemEntityAsset asset) {
        ItemStyle itemStyle = asset.getItemStyle();
        if (itemStyle == null) {
            for (ItemStyle style : ItemStyle.values()) {
                this.styleMap.get((Object)style).add(asset);
            }
        } else {
            this.styleMap.get((Object)itemStyle).add(asset);
        }
    }

    public ItemEntityAsset get(ItemEntityAttributes attributes) {
        List<ItemEntityAsset> assets;
        ItemStyle itemStyle = attributes.getItemStyle();
        if (itemStyle == null) {
            itemStyle = ItemStyle.DEFAULT;
        }
        if ((assets = this.styleMap.get((Object)itemStyle)).size() == 0) {
            System.err.println("Could not find applicable asset for " + attributes.toString());
            return null;
        }
        return assets.get(Math.abs((int)attributes.getSeed()) % assets.size());
    }

    public List<ItemEntityAsset> getAll(ItemEntityAttributes attributes) {
        ItemStyle itemStyle = attributes.getItemStyle();
        if (itemStyle == null) {
            itemStyle = ItemStyle.DEFAULT;
        }
        return this.styleMap.get((Object)itemStyle);
    }
}

